/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.util.Hashtable;

class Watcher
implements Drawable {
    static final Color black = new Color(0, 0, 0);
    static final Font labelFont = new Font("Arial Unicode MS", 1, 10);
    static final int NORMAL_MODE = 1;
    static final int SLIDER_MODE = 2;
    static final int LARGE_MODE = 3;
    PlayerCanvas canvas;
    StretchyBox box;
    WatcherReadout readout;
    StretchyBox slider;
    String label = "x";
    int mode = 1;
    double sliderMin = 0.0;
    double sliderMax = 100.0;
    boolean isDiscrete = false;
    boolean isShowing = true;

    Watcher(LContext lContext) {
        if (lContext != null) {
            this.canvas = lContext.canvas;
        }
        this.box = new StretchyBox();
        this.box.setFrameImage(Skin.watcherOuterFrame);
        this.box.x = 50;
        this.box.y = 50;
        this.readout = new WatcherReadout(false);
        this.readout.color = new Color(74, 107, 214);
        this.slider = new StretchyBox();
        this.slider.setFrameImage(Skin.sliderSlot);
        this.slider.h = 5;
    }

    void show() {
        this.isShowing = true;
        this.inval();
    }

    void hide() {
        this.isShowing = false;
        this.inval();
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public Rectangle rect() {
        return new Rectangle(this.box.x, this.box.y, this.box.w, this.box.h);
    }

    public Rectangle fullRect() {
        return this.rect();
    }

    void inval() {
        this.canvas.inval(this.rect());
    }

    public void paint(Graphics graphics) {
        int n = this.labelWidth(graphics);
        this.readout.beLarge(this.mode == 3);
        this.readout.adjustWidth(graphics);
        this.box.w = n + this.readout.w + 17;
        int n2 = this.box.h = this.mode == 1 ? 21 : 31;
        if (this.mode == 3) {
            this.readout.x = this.box.x;
            this.readout.y = this.box.y;
            this.readout.paint(graphics);
            return;
        }
        this.box.paint(graphics);
        this.drawLabel(graphics);
        this.readout.x = this.box.x + n + 12;
        this.readout.y = this.box.y + 3;
        this.readout.paint(graphics);
        if (this.mode == 2) {
            this.drawSlider(graphics);
        }
    }

    public void paintBubble(Graphics graphics) {
    }

    public void mouseDown(int n, int n2) {
    }

    void drawLabel(Graphics graphics) {
        graphics.setColor(black);
        graphics.setFont(labelFont);
        graphics.drawString(this.label, this.box.x + 6, this.box.y + 14);
    }

    int labelWidth(Graphics graphics) {
        if (this.label.length() == 0) {
            return 0;
        }
        TextLayout textLayout = new TextLayout(this.label, labelFont, ((Graphics2D)graphics).getFontRenderContext());
        return (int)textLayout.getBounds().getBounds().getWidth();
    }

    void drawSlider(Graphics graphics) {
        this.slider.x = this.box.x + 6;
        this.slider.y = this.box.y + 21;
        this.slider.w = this.box.w - 12;
        this.slider.paint(graphics);
        int n = (int)Math.round((double)(this.slider.w - 8) * ((this.getSliderValue() - this.sliderMin) / (this.sliderMax - this.sliderMin)));
        n = Math.max(0, Math.min(n, this.slider.w - 8));
        graphics.drawImage(Skin.sliderKnob, this.slider.x + n - 1, this.slider.y - 3, null);
    }

    boolean inSlider(int n, int n2) {
        if (this.mode != 2) {
            return false;
        }
        if (n2 < this.slider.y - 1 || n2 > this.slider.y + this.slider.h + 4) {
            return false;
        }
        return n >= this.slider.x - 4 && n <= this.slider.x + this.slider.w + 5;
    }

    public void dragTo(int n, int n2) {
        double d = n - this.box.x - 10;
        this.setSliderValue(d * (this.sliderMax - this.sliderMin) / (double)(this.slider.w - 8) + this.sliderMin);
    }

    void click(int n, int n2) {
        int n3;
        double d = this.getSliderValue();
        int n4 = this.slider.x + (int)Math.round((double)(this.slider.w - 8) * ((d - this.sliderMin) / (this.sliderMax - this.sliderMin))) + 5;
        int n5 = n3 = n < n4 ? -1 : 1;
        if (this.isDiscrete) {
            this.setSliderValue(d + (double)n3);
        } else {
            this.setSliderValue(d + (double)n3 * ((this.sliderMax - this.sliderMin) / 100.0));
        }
    }

    double getSliderValue() {
        String string = Logo.prs(this.getObjProp(this, "param"));
        Hashtable hashtable = this.getVarsTable();
        if (string == null || hashtable == null) {
            return (this.sliderMin + this.sliderMax) / 2.0;
        }
        Object v = hashtable.get(Logo.aSymbol(string, this.canvas.lc));
        return v instanceof Number ? ((Number)v).doubleValue() : (this.sliderMin + this.sliderMax) / 2.0;
    }

    void setSliderValue(double d) {
        double d2 = this.isDiscrete ? (double)Math.round(d) : d;
        d2 = Math.min(this.sliderMax, Math.max(this.sliderMin, d2));
        String string = Logo.prs(this.getObjProp(this, "param"));
        Hashtable hashtable = this.getVarsTable();
        if (string == null || hashtable == null) {
            return;
        }
        hashtable.put(Logo.aSymbol(string, this.canvas.lc), new Double(d2));
        this.inval();
    }

    Hashtable getVarsTable() {
        String string = Logo.prs(this.getObjProp(this, "op"));
        String string2 = Logo.prs(this.getObjProp(this, "param"));
        Object object = this.getObjProp(this, "target");
        if (object == null || !string.equals("getVar:")) {
            return null;
        }
        Object object2 = this.getObjProp(object, "vars");
        if (object2 == null) {
            return null;
        }
        return (Hashtable)this.canvas.lc.props.get(object2);
    }

    Object getObjProp(Object object, String string) {
        Hashtable hashtable = (Hashtable)this.canvas.lc.props.get(object);
        if (hashtable == null) {
            return null;
        }
        return hashtable.get(Logo.aSymbol(string, this.canvas.lc));
    }
}

