/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;

class AskPrompter
extends StretchyBox {
    int fontSize = 11;
    Font font = new Font("Arial Unicode MS", 1, this.fontSize);
    Font answerFont = new Font("Arial Unicode MS", 0, 13);
    FontRenderContext renderContext = Skin.askBubbleFrame.createGraphics().getFontRenderContext();
    String promptString = "";
    String answerString = "";
    int lineX;
    int lineY;

    AskPrompter(String string) {
        this.setFrameImage(Skin.askBubbleFrame);
        this.setPrompt(string);
    }

    void setPrompt(String string) {
        int n = string.length() == 0 ? 1 : 2;
        this.promptString = string;
        this.x = 15;
        this.w = 452;
        this.h = n * (this.fontSize + 4) + 22;
        this.y = 378 - this.h;
    }

    public Rectangle rect() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.lineX = this.x + 12;
        this.lineY = this.y + this.fontSize + 14;
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.setFont(this.font);
        if (this.promptString.length() > 0) {
            graphics2D.drawString(this.promptString, this.lineX - 2, this.lineY - 8);
            this.lineY += this.fontSize + 4;
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(new Color(213, 213, 213));
        graphics2D.drawLine(this.lineX - 4, this.lineY - this.fontSize - 5, this.lineX - 4 + this.w - 38, this.lineY - this.fontSize - 5);
        graphics2D.drawLine(this.lineX - 4, this.lineY - this.fontSize - 5, this.lineX - 4, this.lineY - this.fontSize - 5 + this.fontSize + 9);
        graphics2D.setColor(new Color(242, 242, 242));
        graphics2D.fillRect(this.lineX - 3, this.lineY - this.fontSize - 4, this.w - 39, this.fontSize + 8);
        Shape shape = graphics.getClip();
        graphics.setClip(this.lineX - 3, this.lineY - this.fontSize - 4, this.w - 39, this.fontSize + 8);
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.setFont(this.answerFont);
        graphics2D.drawString(this.answerString, this.lineX, this.lineY - 1);
        graphics.setClip(shape);
        graphics2D.drawImage(Skin.promptCheckButton, null, this.lineX + this.w - 38, this.lineY - this.fontSize - 6);
    }

    public boolean mouseDown(int n, int n2, PlayerCanvas playerCanvas) {
        if (n > this.lineX + this.w - 38 && n < this.lineX + this.w - 38 + 20 && n2 > this.lineY - this.fontSize - 6 && n2 < this.lineY - this.fontSize - 6 + 20) {
            playerCanvas.hideAskPrompt();
            return true;
        }
        return false;
    }

    public void handleKeystroke(int n, PlayerCanvas playerCanvas) {
        playerCanvas.inval(this.rect());
        if (n == 3 || n == 10) {
            playerCanvas.hideAskPrompt();
            return;
        }
        if (n == 8 || n == 127) {
            if (this.answerString.length() > 0) {
                this.answerString = this.answerString.substring(0, this.answerString.length() - 1);
            }
            return;
        }
        char[] cArray = new char[]{(char)n};
        if (n >= 32) {
            this.answerString = this.answerString + new String(cArray);
        }
    }
}

