/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

class Sprite
implements Drawable {
    static final int originX = 241;
    static final int originY = 206;
    PlayerCanvas canvas;
    BufferedImage costume;
    BufferedImage rotatedCostume;
    BufferedImage filteredCostume;
    BufferedImage tempImage;
    double x;
    double y;
    boolean isShowing = true;
    boolean isDraggable = false;
    double alpha = 1.0;
    double scale = 1.0;
    double rotationDegrees = 90.0;
    int rotationstyle;
    int rotationX;
    int rotationY;
    int offsetX;
    int offsetY;
    Bubble bubble;
    boolean penDown;
    int lastPenX;
    int lastPenY;
    Color penColor = new Color(0, 0, 255);
    int penSize = 1;
    double penHue;
    double penShade;
    boolean filterChanged = false;
    double color;
    double brightness;
    double fisheye;
    double whirl;
    double mosaic;
    double pixelate;
    ImageFilter imageFilter = new ImageFilter();

    Sprite(LContext lContext) {
        this.setPenColor(this.penColor);
        if (lContext != null) {
            this.canvas = lContext.canvas;
        }
    }

    int screenX() {
        return 241 + (int)(this.x - (double)this.offsetX);
    }

    int screenY() {
        return 206 + (int)(-this.y - (double)this.offsetY);
    }

    void setscreenX(double d) {
        this.x = d + (double)this.offsetX - 241.0;
    }

    void setscreenY(double d) {
        this.y = -(d + (double)this.offsetY - 206.0);
    }

    public void mouseDown(int n, int n2) {
    }

    void setStageOffset() {
        this.y = 0.0;
        this.x = 0.0;
        this.offsetX = this.costume.getWidth(null) / 2;
        this.offsetY = this.costume.getHeight(null) / 2;
    }

    public void dragTo(int n, int n2) {
        this.inval();
        this.setscreenX(n);
        this.setscreenY(n2);
        this.updateBubble();
        this.inval();
    }

    boolean containsPoint(int n, int n2) {
        BufferedImage bufferedImage = this.outImage();
        int n3 = this.screenX();
        int n4 = this.screenY();
        int n5 = bufferedImage.getWidth(null);
        int n6 = bufferedImage.getHeight(null);
        if (n < n3 || n >= n3 + n5 || n2 < n4 || n2 >= n4 + n6) {
            return false;
        }
        int n7 = bufferedImage.getRGB(n - n3, n2 - n4);
        return (n7 & 0xFF000000) != 0;
    }

    boolean touchingSprite(Object object, LContext lContext) {
        if (!(object instanceof Sprite)) {
            Logo.error("argument must be a Sprite", lContext);
            return false;
        }
        Sprite sprite = (Sprite)object;
        Rectangle rectangle = this.rect().intersection(sprite.rect());
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return false;
        }
        BufferedImage bufferedImage = this.outImage();
        BufferedImage bufferedImage2 = sprite.outImage();
        int n = rectangle.x - this.screenX();
        int n2 = rectangle.y - this.screenY();
        int n3 = rectangle.x - sprite.screenX();
        int n4 = rectangle.y - sprite.screenY();
        for (int i = n2; i < n2 + rectangle.height; ++i) {
            int n5 = n3;
            for (int j = n; j < n + rectangle.width; ++j) {
                int n6 = bufferedImage.getRGB(j, i);
                int n7 = bufferedImage2.getRGB(n5, n4);
                if ((n6 & 0xFF000000) != 0 && (n7 & 0xFF000000) != 0) {
                    return true;
                }
                ++n5;
            }
            ++n4;
        }
        return false;
    }

    boolean touchingColor(Object object, LContext lContext) {
        if (!(object instanceof Color)) {
            Logo.error("argument of touchingColor? must be a Color", lContext);
            return false;
        }
        int n = ((Color)object).getRGB() | 0xFF000000;
        Rectangle rectangle = this.rect();
        BufferedImage bufferedImage = this.outImage();
        BufferedImage bufferedImage2 = lContext.canvas.drawAreaWithoutSprite(rectangle, this);
        for (int i = 0; i < rectangle.height; ++i) {
            for (int j = 0; j < rectangle.width; ++j) {
                if ((bufferedImage.getRGB(j, i) & 0xFF000000) == 0 || !this.colorsMatch(bufferedImage2.getRGB(j, i), n)) continue;
                bufferedImage2.flush();
                return true;
            }
        }
        bufferedImage2.flush();
        return false;
    }

    boolean colorTouchingColor(Object object, Object object2, LContext lContext) {
        if (!(object instanceof Color) || !(object2 instanceof Color)) {
            Logo.error("the arguments of colorTouchingColor? must be Colors", lContext);
            return false;
        }
        int n = ((Color)object).getRGB() | 0xFF000000;
        int n2 = ((Color)object2).getRGB() | 0xFF000000;
        Rectangle rectangle = this.rect();
        BufferedImage bufferedImage = this.outImage();
        BufferedImage bufferedImage2 = lContext.canvas.drawAreaWithoutSprite(rectangle, this);
        for (int i = 0; i < rectangle.height; ++i) {
            for (int j = 0; j < rectangle.width; ++j) {
                if (!this.colorsMatch(bufferedImage.getRGB(j, i), n) || !this.colorsMatch(bufferedImage2.getRGB(j, i), n2)) continue;
                bufferedImage2.flush();
                return true;
            }
        }
        bufferedImage2.flush();
        return false;
    }

    boolean colorsMatch(int n, int n2) {
        if ((n & 0xFF000000) != (n2 & 0xFF000000)) {
            return false;
        }
        if ((n >> 16 & 0xF8) != (n2 >> 16 & 0xF8)) {
            return false;
        }
        if ((n >> 8 & 0xF8) != (n2 >> 8 & 0xF8)) {
            return false;
        }
        if ((n & 0xFFFF00) == 0 && (n2 & 0xFFFF00) == 0 && (n & 0xFF) <= 8 && (n2 & 0xFF) <= 8) {
            return true;
        }
        return (n & 0xF8) == (n2 & 0xF8);
    }

    void setalpha(Object object, LContext lContext) {
        double d = Logo.aDouble(object, lContext);
        if (d < 0.0) {
            d = -d;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.alpha = d;
        this.inval();
    }

    void setcostume(Object object, Object object2, Object object3, LContext lContext) {
        if (!(object instanceof BufferedImage)) {
            return;
        }
        this.rotationX = Logo.anInt(object2, lContext);
        this.rotationY = Logo.anInt(object3, lContext);
        if (this.costume != null) {
            this.inval();
        }
        this.costume = (BufferedImage)object;
        this.rotateAndScale();
        this.inval();
    }

    void costumeChanged() {
        this.inval();
        this.rotateAndScale();
        this.inval();
    }

    void setscale(Object object, LContext lContext) {
        double d = Logo.aDouble(object, lContext);
        double d2 = Math.min(this.costume.getWidth(null), 10);
        double d3 = Math.min(this.costume.getHeight(null), 10);
        double d4 = Math.max(d2 / 480.0, d3 / 360.0);
        double d5 = Math.min(480.0 / (double)this.costume.getWidth(null), 360.0 / (double)this.costume.getHeight(null));
        this.scale = Math.min(Math.max(d, d4), d5);
        this.costumeChanged();
    }

    void rotateAndScale() {
        double d;
        this.filterChanged = true;
        double d2 = d = this.rotationstyle == 0 ? this.rotationDegrees : 90.0;
        if (this.rotatedCostume != null && this.rotatedCostume != this.costume) {
            this.rotatedCostume.flush();
        }
        if (this.scale == 1.0 && this.rotationDegrees == 90.0) {
            this.rotatedCostume = this.costume;
            this.offsetX = this.rotationX;
            this.offsetY = this.rotationY;
            return;
        }
        int n = this.costume.getWidth(null);
        int n2 = this.costume.getHeight(null);
        double d3 = Math.toRadians(d - 90.0);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d3, n / 2, n2 / 2);
        affineTransform.scale(this.scale, this.scale);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        Rectangle2D.Float float_ = (Rectangle2D.Float)affineTransformOp.getBounds2D(this.costume);
        float f = -float_.x;
        float f2 = -float_.y;
        affineTransform = AffineTransform.getRotateInstance(d3, (float)(n / 2) + f, (float)(n2 / 2) + f2);
        affineTransform.translate(f, f2);
        affineTransform.scale(this.scale, this.scale);
        affineTransformOp = new AffineTransformOp(affineTransform, 2);
        this.rotatedCostume = affineTransformOp.filter(this.costume, null);
        affineTransform = AffineTransform.getRotateInstance(d3, 0.0, 0.0);
        affineTransform.scale(this.scale, this.scale);
        Point2D point2D = affineTransform.transform(new Point2D.Double(this.rotationX - n / 2, this.rotationY - n2 / 2), null);
        this.offsetX = (int)(point2D.getX() + (double)(this.rotatedCostume.getWidth(null) / 2));
        this.offsetY = (int)(point2D.getY() + (double)(this.rotatedCostume.getHeight(null) / 2));
        if (this.rotationstyle == 1) {
            double d4;
            double d5 = d4 = this.rotationDegrees < 0.0 ? this.rotationDegrees + 360.0 : this.rotationDegrees;
            if (d4 <= 180.0) {
                return;
            }
            int n3 = this.rotatedCostume.getWidth(null);
            affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
            affineTransform.translate(-n3, 0.0);
            affineTransformOp = new AffineTransformOp(affineTransform, 2);
            this.rotatedCostume = affineTransformOp.filter(this.rotatedCostume, null);
            this.offsetX = (int)((double)(n3 / 2) - this.scale * (double)(this.rotationX - n / 2));
            this.offsetY = (int)(this.scale * (double)this.rotationY);
        }
    }

    void show() {
        this.isShowing = true;
        this.inval();
    }

    void hide() {
        this.isShowing = false;
        this.inval();
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public boolean isVisible() {
        return this.isShowing && this.alpha > 0.0;
    }

    public Rectangle rect() {
        BufferedImage bufferedImage = this.outImage();
        if (bufferedImage == null) {
            return new Rectangle(this.screenX(), this.screenY(), 600, 600);
        }
        return new Rectangle(this.screenX(), this.screenY(), bufferedImage.getWidth(null), bufferedImage.getHeight(null));
    }

    public Rectangle fullRect() {
        Rectangle rectangle = this.rect();
        if (this.bubble != null) {
            rectangle = rectangle.union(this.bubble.rect());
        }
        return rectangle;
    }

    void inval() {
        this.canvas.inval(this.fullRect());
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.filterChanged) {
            this.applyFilters();
        }
        if (this.alpha != 1.0) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.alpha));
            graphics2D.drawImage((Image)this.outImage(), this.screenX(), this.screenY(), null);
            graphics2D.setComposite(composite);
        } else {
            graphics2D.drawImage((Image)this.outImage(), this.screenX(), this.screenY(), null);
        }
    }

    public void paintBubble(Graphics graphics) {
        if (this.bubble != null) {
            this.bubble.paint(graphics);
        }
    }

    void talkbubble(Object object, boolean bl, boolean bl2, LContext lContext) {
        String string = object instanceof String ? (String)object : Logo.prs(object);
        this.inval();
        this.bubble = null;
        if (string.length() == 0) {
            return;
        }
        this.bubble = new Bubble();
        if (bl) {
            this.bubble.beAskBubble();
        }
        if (!bl2) {
            this.bubble.beThinkBubble(true);
        }
        this.bubble.setContents(string);
        if (this.rotationDegrees >= 0.0 && this.rotationDegrees <= 180.0) {
            this.bubble.pointLeft = true;
        }
        this.updateBubble();
    }

    void updateBubble() {
        int n = 3;
        int n2 = 482 - n;
        if (this.bubble == null) {
            return;
        }
        this.inval();
        Rectangle rectangle = this.rect();
        boolean bl = this.bubble.pointLeft;
        int[] nArray = this.bubbleInsets();
        if (bl && rectangle.x + rectangle.width - nArray[1] + this.bubble.w + n > n2) {
            bl = false;
        }
        if (!bl && rectangle.x + nArray[0] - this.bubble.w - n < 0) {
            bl = true;
        }
        if (bl) {
            this.bubble.pointLeft = true;
            this.bubble.x = rectangle.x + rectangle.width - nArray[1] + n;
        } else {
            this.bubble.pointLeft = false;
            this.bubble.x = rectangle.x + nArray[0] - this.bubble.w - n;
        }
        if (this.bubble.x + this.bubble.w > n2) {
            this.bubble.x = n2 - this.bubble.w;
        }
        if (this.bubble.x < n) {
            this.bubble.x = n;
        }
        this.bubble.y = Math.max(rectangle.y - this.bubble.h - 12, 25 + n);
        if (this.bubble.y + this.bubble.h > 387) {
            this.bubble.y = 387 - this.bubble.h;
        }
        this.inval();
    }

    int[] bubbleInsets() {
        BufferedImage bufferedImage = this.outImage();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = n;
        int n4 = n;
        int n5 = -1;
        for (int i = 0; i < n2; ++i) {
            boolean bl = false;
            for (int j = 0; j < Math.max(n3, n4); ++j) {
                int n6 = bufferedImage.getRGB(j, i) & 0xFF000000;
                if (n6 != 0 && j < n3) {
                    n3 = j;
                    bl = true;
                }
                if ((n6 = bufferedImage.getRGB(n - j - 1, i) & 0xFF000000) == 0 || j >= n4) continue;
                n4 = j;
                bl = true;
            }
            if (n5 < 0) {
                if (!bl) continue;
                n5 = i;
                continue;
            }
            if (i >= n5 + 10) break;
        }
        int[] nArray = new int[]{n3, n4};
        return nArray;
    }

    void setPenDown(boolean bl) {
        if (bl == this.penDown) {
            return;
        }
        if (bl) {
            this.lastPenY = -1000000;
            this.lastPenX = -1000000;
        }
        this.canvas.updatePenTrailForSprite(this);
        this.penDown = bl;
    }

    void setPenColor(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.penColor = color;
        this.penHue = 200.0 * (double)fArray[0];
        float f = fArray[1];
        float f2 = fArray[2];
        this.penShade = (double)f2 == 1.0 ? 50.0 + 50.0 * (1.0 - (double)f) : 50.0 * (double)f2;
    }

    void setPenHue(double d) {
        this.penHue = d % 200.0;
        if (this.penHue < 0.0) {
            this.penHue = 200.0 + this.penHue;
        }
        this.setPenShade(this.penShade);
    }

    void setPenShade(double d) {
        float f;
        this.penShade = d % 200.0;
        if (this.penShade < 0.0) {
            this.penShade = 200.0 + this.penShade;
        }
        if ((double)(f = (float)(this.penShade > 100.0 ? 200.0 - this.penShade : this.penShade)) <= 50.0) {
            float f2 = (f + 10.0f) / 60.0f;
            this.penColor = new Color(Color.HSBtoRGB((float)(this.penHue / 200.0), 1.0f, f2));
        } else {
            float f3 = (100.0f - f + 10.0f) / 60.0f;
            this.penColor = new Color(Color.HSBtoRGB((float)(this.penHue / 200.0), f3, 1.0f));
        }
    }

    BufferedImage outImage() {
        if (this.filteredCostume != null) {
            return this.filteredCostume;
        }
        if (this.rotatedCostume != null) {
            return this.rotatedCostume;
        }
        return this.costume;
    }

    void applyFilters() {
        if (!this.filtersActive()) {
            this.filteredCostume = null;
            this.filterChanged = false;
            return;
        }
        this.imageFilter.setSourceImage(this.rotatedCostume != null ? this.rotatedCostume : this.costume);
        if (this.color != 0.0) {
            this.imageFilter.applyHueShift((int)this.color);
        }
        if (this.brightness != 0.0) {
            this.imageFilter.applyBrightnessShift((int)this.brightness);
        }
        if (this.whirl != 0.0) {
            this.imageFilter.applyWhirl(this.whirl);
        }
        if (this.fisheye != 0.0) {
            this.imageFilter.applyFisheye(this.fisheye);
        }
        if (Math.abs(this.pixelate) >= 5.0) {
            this.imageFilter.applyPixelate(this.pixelate);
        }
        if (Math.abs(this.mosaic) >= 5.0) {
            this.imageFilter.applyMosaic(this.mosaic);
        }
        this.filteredCostume = this.imageFilter.filteredImage;
        this.filterChanged = false;
    }

    boolean filtersActive() {
        return this.color != 0.0 || this.brightness != 0.0 || this.fisheye != 0.0 || this.whirl != 0.0 || Math.abs(this.mosaic) >= 5.0 || Math.abs(this.pixelate) >= 5.0;
    }
}

