/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Insets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class DesktopScratchViewer {
    static JFrame parent;

    public static void main(String[] args) throws IOException {
        try {
            DesktopScratchViewer.setFinalStatic(PlayerPrims.class.getDeclaredField("primclasses"), new String[]{"SystemPrims", "MathPrims", "ControlPrims", "DefiningPrims", "WordListPrims", "FilePrims", "PlayerPrims", "SpritePrims", "PantherPrims"});
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error: can't set final field 'primclasses'!\nNo Panther support.", "Error", 0);
        }
        Properties p = new Properties();
        p.loadFromXML(DesktopScratchViewer.class.getResourceAsStream("config.xml"));
        String[] params = new String[p.size() * 2];
        Enumeration<Object> keys = p.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            System.out.println(key + "=" + p.getProperty(key));
            params[i] = key;
            params[i + 1] = p.getProperty(key);
            i += 2;
        }
        try {
            UIManager.LookAndFeelInfo[] info;
            for (UIManager.LookAndFeelInfo laf : info = UIManager.getInstalledLookAndFeels()) {
                if (!laf.getName().equals("Nimbus")) continue;
                UIManager.setLookAndFeel(laf.getClassName());
                break;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        final JFrame frm = new JFrame(DesktopScratchViewer.getParam(params, "title"));
        final DesktopScratchApplet app = new DesktopScratchApplet(params);
        final LoadingPanel load = new LoadingPanel();
        parent = frm;
        frm.setLocationByPlatform(true);
        frm.setDefaultCloseOperation(3);
        frm.setLayout(null);
        frm.add(load);
        frm.add(app);
        app.setBounds(0, -25, 482, 387);
        load.setBounds(0, 0, 482, 387);
        frm.validate();
        frm.setResizable(false);
        frm.setVisible(true);
        Insets iset = frm.getInsets();
        frm.setSize(482 + iset.left + iset.right, 387 + iset.top + iset.bottom - 25);
        app.init();
        new Thread(){

            @Override
            public void run() {
                while (app.lc.canvas.isLoading) {
                    load.Progress.setValue((int)(app.lc.canvas.loadingFraction * 100.0));
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                frm.remove(load);
                frm.validate();
            }
        }.start();
    }

    private static String getParam(String[] params, String name) {
        for (int i = 0; i < params.length; i += 2) {
            if (!params[i].equals(name)) continue;
            return params[i + 1];
        }
        return null;
    }

    private static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    private static class DesktopScratchApplet
    extends ScratchApplet {
        private String[] param;

        public DesktopScratchApplet(String[] params) {
            this.param = params;
        }

        @Override
        public String getParameter(String name) {
            for (int i = 0; i < this.param.length; i += 2) {
                if (!this.param[i].equals(name)) continue;
                return this.param[i + 1];
            }
            return null;
        }

        @Override
        public URL getCodeBase() {
            try {
                return new URL(DesktopScratchViewer.class.getResource("project.dat").toExternalForm().replace("project.dat", ""));
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class LoadingPanel
    extends JPanel {
        public JProgressBar Progress;

        public LoadingPanel() {
            this.initComponents();
        }

        private void initComponents() {
            this.Progress = new JProgressBar();
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.Progress, -1, 430, Short.MAX_VALUE).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(155, Short.MAX_VALUE).addComponent(this.Progress, -2, 57, -2).addGap(118, 118, 118)));
        }
    }
}

