/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class ADPCMDecoder {
    static final int[] stepSizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    static final int[] indices2bit = new int[]{-1, 2};
    static final int[] indices3bit = new int[]{-1, -1, 2, 4};
    static final int[] indices4bit = new int[]{-1, -1, -1, -1, 2, 4, 6, 8};
    static final int[] indices5bit = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, 4, 6, 8, 10, 13, 16};
    DataInputStream in;
    int bitsPerSample;
    int currentByte;
    int bitPosition;
    int[] indexTable;
    int predicted;
    int index;

    ADPCMDecoder(byte[] byArray, int n) {
        this(new ByteArrayInputStream(byArray), n);
    }

    ADPCMDecoder(InputStream inputStream, int n) {
        this.in = new DataInputStream(inputStream);
        this.bitsPerSample = n;
        switch (this.bitsPerSample) {
            case 2: {
                this.indexTable = indices2bit;
                break;
            }
            case 3: {
                this.indexTable = indices3bit;
                break;
            }
            case 4: {
                this.indexTable = indices4bit;
                break;
            }
            case 5: {
                this.indexTable = indices5bit;
            }
        }
    }

    int[] decode(int n) {
        int n2 = 1 << this.bitsPerSample - 1;
        int n3 = n2 - 1;
        int n4 = n2 >> 1;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n5 = this.nextBits();
            int n6 = stepSizeTable[this.index];
            int n7 = 0;
            for (int j = n4; j > 0; j >>= 1) {
                if ((n5 & j) != 0) {
                    n7 += n6;
                }
                n6 >>= 1;
            }
            this.predicted += (n5 & n2) != 0 ? -n7 : (n7 += n6);
            if (this.predicted > Short.MAX_VALUE) {
                this.predicted = Short.MAX_VALUE;
            }
            if (this.predicted < Short.MIN_VALUE) {
                this.predicted = Short.MIN_VALUE;
            }
            nArray[i] = this.predicted;
            this.index += this.indexTable[n5 & n3];
            if (this.index < 0) {
                this.index = 0;
            }
            if (this.index <= 88) continue;
            this.index = 88;
        }
        return nArray;
    }

    int nextBits() {
        int n;
        int n2;
        block3: {
            n2 = 0;
            n = this.bitsPerSample;
            do {
                int n3;
                n2 += (n3 = n - this.bitPosition) < 0 ? this.currentByte >> -n3 : this.currentByte << n3;
                if (n3 <= 0) break block3;
                n -= this.bitPosition;
                try {
                    this.currentByte = this.in.readUnsignedByte();
                }
                catch (IOException iOException) {
                    this.currentByte = -1;
                }
                this.bitPosition = 8;
            } while (this.currentByte >= 0);
            this.bitPosition = 0;
            return n2;
        }
        this.bitPosition -= n;
        this.currentByte &= 255 >> 8 - this.bitPosition;
        return n2;
    }
}

